#ifndef MEMORYDC_H
#define MEMORYDC_H
#include "types.h"
/* The MemoryDC class is used to maintain a bitmap copy of your
window for restoring it.  MemoryDC uses a constructor that
takes an HWND as param.  To declare it globally, put at the top a global:
MemoryDC *wbm;
then in WM_CREATE: put
	wbm = new MemoryDC(hwnd, backgroundcolor);
backgroundcolor should be RGB(0,0,0) or RGB(255,255,255), depending on
whether your wndclass.hbrBackground is BLACK_BRUSH or WHITE_BRUSH.
In WM_PAINT: put
	hdc = BeginPaint(hwnd, &ps);
	wbm->CopyTo(hdc, ps.rcPaint);
	//Possible other screen writing
	EndPaint(hwnd, &ps);
In WM_DESTROY put
	delete wbm;
and to CLEAR the window put
	wbm->Clear();
	InvalidateRect(hwnd, NULL, FALSE);
Use the standard Windows API GUI calls to write graphics, except use
wbm->hdc() as the HDC argument.  Like, for instance,
	SetPixel(wbm->hdc(), x, y, col);
Whenever you finish a message case which does these writes to
the MemoryDC, you do a
	InvalidateRect(hwnd, NULL, FALSE);
to BitBlt the altered MemoryDC to the screen.*/

class MemoryDC
{
private:
	HBITMAP _hbitmap;
	HDC _hdc;
	HBRUSH _hblankbrush;
	int _cx, _cy;
public:
	MemoryDC(HWND hwnd, COLORREF blankcol); //constructor
	~MemoryDC(); //destructor
	int cx(){return _cx;}
	int cy(){return _cy;} //accessors
	HDC hdc(){return _hdc;}
	void Clear();
	void CopyTo(HDC hdc, RECT rect);
};
#endif //MEMORYDC_H